/*This SAS code reads in the dataset and then uses the means procedure
to produce the information plotted in the Box 1.l*/

Data Chapter1;
input bestteachers majority Passing count;
DATALINES;
0	0	0	200
0	0	1	300
0	1	0	150
0	1	1	350
1	0	0	125
1	0	1	375
1	1	0	125
1	1	1	375

;

data chapter1; set chapter1;

	/* These three runs use the crosstabulation procedure*/

Title 'Box 1.1 majority students pass more frequently, no control for teachers';
proc freq; tables passing*majority/ all;
weight count;
Run;

Title 'Box 1.1 best teachers induce passing, no control for ethnicity of students';
proc freq; tables passing*bestteachers /all;
weight count;
Run;

Title 'Box 1.2 best teachers reduce the relationship between ethnicity and passing';
proc freq; tables bestteachers*passing*majority;
weight count;
Run;

	/* These two runs apply Proc Reg to quantify the effects*/

Proc reg data = chapter1;
model  passing = majority bestteachers /stb tol vif;
freq count;
run;

data interaction; set chapter1;
	/*this code creates the interaction effect*/
interact = 0;
if majority = 1 and bestteachers = 1 then interact = 1;

	/*this code estimates the interaction effect and the main effects*/
proc reg data =	interaction;
model passing = majority bestteachers interact/ stb tol vif;
freq count;
run;


/* To obtain nuanced parameter estimates and their statistical significance, the following SAS Code 
applies the Glimmix procedure assuming that passing requires a binomial distribution and
a logit link. 
	In the Proc Glimmix statement the OR requests odds ratios. The pq option on the information
criteria (ic option) includes penalties in the calculation of the AIC and BIC for the number 
of fixed-effects parameters in the model.  
	In the model statement and in the lsmeans statement cl requests confidence limits.
	In the least-squares means (lsmeans) statements the ilink option converts the logit-scale parameters
to proportions; the pdiff option request the differences between the means and their significance.
	The output includes the predicted values and residuals on the proportion scale (ilink) and on the 
	logit scale	(noilink).
*/


Title ' Glimmix Model 1: No interaction effect pq option no random intercepts no random residual';

PROC glimmix data = chapter1 OR ic = pq;
	Freq count;
	Class bestteachers majority;
	Model passing = bestteachers majority /s cl dist = binomial link = logit;
	*random intercept / type= un subject = bestteachers g s;
	*random _residual_;
	lsmeans majority / ilink pdiff cl;
	lsmeans bestteachers/ ilink pdiff cl;
	output out=modelg1
	pred(blup ilink)= pilink   pred(blup noilink) = pnoilink
	resid(blup ilink)=rilink  resid(blup noilink) = rnoilink; 
run;

data modelg2; set modelg1;
Title 'Glimmix Model 1, binomial no random effects';
	proc print; 
run;

/* Glimmix Model 2 is similar to Gimmix Model 1 but it includes the cross-level contextual effect parameter.*/
Title 'Glimix Model 2 binomial no random effects, intercepts + majority|bestteachers, pq option no type un';
PROC glimmix  DATA= chapter1 or ic = pq; 
	freq count;
	class bestteachers majority;
	model passing = bestteachers|majority /s cl dist = binomial link = logit;
	*random intercept / type= un subject = bestteachers g s;
	*random _residual_;
	lsmeans bestteachers|majority/ ilink or pdiff cl;
	output out=modelg3
	pred(blup ilink)= pilink   pred(blup noilink) = pnoilink
	resid(blup ilink)=rilink  resid(blup noilink) = rnoilink; 
run;

data modelg4; set modelg3;
Title 'Glimmix Model 2 binomial with interaction but without random intercepts ';
proc print; run;
run;

/* This syntax is copyright by Robert B. Smith  2011.*/
